<?php

// CAPTCHA
$captcha = array('WDZZ','APYH','ANSN','CJNO','NRLA','JYPN','MXLU','ZVZB','VNQS','GKIR','BSES','CRUM','GUKI','ORWJ','LNZA','DMTE','WOJP','RTIM','SGVA','EYNK','PRND','SYTR','UFGP','UEUN','CUCW','KHBZ');

// Set JSON format (for response)
header('Content-Type: application/json');
  
// Collect form data
$ufname = $_POST['ufname'];
$ulname = $_POST['ulname'];
$uemail = $_POST['uemail'];
$uphone = $_POST['uphone'];
$uinterest = $_POST['uinterest'];
$ucaptcha = $_POST['ucaptcha'];
$urand_captcha = $_POST['urand_captcha'];

// Check data
if(empty($ufname)):
  echo json_encode([
    'success' => false,
    'error' => '<p class="alert">Please provide your first name.</p>'
  ]); exit;
elseif(empty($ulname)):
  echo json_encode([
    'success' => false,
    'error' => '<p class="alert">Please provide your last name.</p>'
  ]); exit;
elseif(!filter_var($uemail, FILTER_VALIDATE_EMAIL)):
  echo json_encode([
    'success' => false,
    'error' => '<p class="alert">Please provide a valid email address.</p>'
  ]); exit;
elseif(empty($uphone)):
  echo json_encode([
    'success' => false,
    'error' => '<p class="alert">Please provide your phone number.</p>'
  ]); exit;
elseif(empty($uinterest)):
  echo json_encode([
    'success' => false,
    'error' => '<p class="alert">Please let us know what you\'re interested in.</p>'
  ]); exit;
elseif($ucaptcha != $captcha[$urand_captcha]):
  echo json_encode([
    'success' => false,
    'error' => '<p class="alert">You did not pass the security check.</p>'
  ]); exit;

else:

  // -------------------------------------------------- // 
  // If interested in employment...
  // -------------------------------------------------- // 
  if($uinterest == 'Employment'):

    // Send email notification
    $kirby->email([
    'from' => 'info@weathervanesl.com',
    'to' => 'rbtemployment@weathervanesl.com', // dedicated employment email
    'subject' => 'Form Submission - The Residence at Boyertown',
    'body'=> "Hello,\n\nA visitor who is interested in employment submitted a message from theresidenceatboyertown.com. See details below.\n\nFirst name: ". $ufname ."\nLast name: ". $ulname ."\nEmail: ". $uemail ."\nPhone: ". $uphone ."\nInterest/Type of Service: ". $uinterest ."\n\n---\n\nThis message was automatically sent from theresidenceatboyertown.com.\n\n",
    ]);

    // Redirect Careers page
    echo json_encode([
      'success' => true,
      'redirect_url' => '/careers'
    ]); exit;
    
  endif;
  // -------------------------------------------------- // 

  // Define Move-N data
  $property_id = '631230'; // Boyertown
  $parent_id = '1146';    
  $source_code_id = time(); // Generate unique number, <= 10 characters, that increments

  // Set 'test' or 'live' environment 
  $moven_env = 'live'; 
  if($moven_env == 'live'):
    $sender_id = '00c68036af536b4aa5e2d18800567410976156cc'; 
    $url = 'https://cp.move-n.com/api/Lead/LeadInfo';
  else:
    $sender_id = 'c5b0bed7041f2ebf1eef64c1b332ac853aa621fe';
    $url = 'https://test-api.move-n.com/api/lead/leadinfo';
  endif;

  // Build the data array with the form data
  $data = [
    'sender_id' => $sender_id,
    'source_code' => '1',
    'parent_id' => $parent_id,
    'property_id' => $property_id,
    'prospect_first_name' => $ufname, 
    'prospect_last_name' => $ulname,
    'first_name' => $ufname,
    'last_name' => $ulname,
    'email' => $uemail,
    'home_phone' => $uphone,
    'TypeOfService' => $uinterest,
    'notes' => 'Website contact form. Interested in '. $uinterest 
  ];

  // Initialize cURL
  $ch = curl_init();

  // Set the URL and other options
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 

  // Execute the request and capture the response
  $response = curl_exec($ch);

  // Check for errors
  if(!str_contains($response, 'Successfully')):
    echo json_encode([
      'success' => false,
      'error' => '<p class="alert">'. $response .'</p>'
    ]); exit;
  
  else:
    
    // Set recipient
    if(page('home')->contact_recipient()->isNotEmpty()):
      // tsanelli@weathervanesl.com
      $recipient = page('home')->contact_recipient()->value();
    else:
      $recipient = 'support@thewebprojects.com';
    endif;

    // Send off email 
    $kirby->email([
    'from' => 'info@weathervanesl.com',
    'to' => $recipient,
    'subject' => 'Form Submission - The Residence at Boyertown',
    'body'=> "Hello,\n\nA visitor submitted a message from theresidenceatboyertown.com. See details below.\n\nFirst name: ". $ufname ."\nLast name: ". $ulname ."\nEmail: ". $uemail ."\nPhone: ". $uphone ."\nInterest/Type of Service: ". $uinterest ."\n\nResponse from CRM: ". $response ."\n\n---\n\nThis message was automatically sent from theresidenceatboyertown.com.\n\n",
    ]);

    // Redirect to confirmation page
    echo json_encode([
      'success' => true,
      'redirect_url' => '/contact-thanks'
    ]); exit;
  endif;

  // Close cURL session
  curl_close($ch);

endif;  