<?php snippet('header') ?>

<?php snippet('intro') ?>

<section class="sec-gen insight">
	<div class="container-med">
		<?php snippet('blocks') ?>
	</div>
</section>

<?php // Navigate through articles 
$items = $page->siblings()->listed()->filterBy('pub_date', '<=', date('Y-m-d'))->sortBy('pub_date', 'desc');
if($prev = $page->prev($items) || $next = $page->next($items)): ?>
<div class="sec-gen bg-alt pagination">
	<div class="container-med">		
		<p class="btns center">
			<?php if($prev = $page->prev($items)): ?>
			<a class="btn" href="<?= $prev->url() ?>" title="Previous Article">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M7 18V6H9V18H7ZM11 12 17 6V18L11 12Z"></path></svg>
			</a>
			<?php endif ?>
			<?php if($next = $page->next($items)): ?>
			<a class="btn" href="<?= $next->url() ?>" title="Next Article">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M17 6 17 18H15L15 6 17 6ZM13 12 7 18V6L13 12Z"></path></svg>
			</a>
			<?php endif ?>
		</p>
	</div>
</div>
<?php endif ?>

<?php snippet('footer') ?>