<?php snippet('header') ?>

<?php snippet('intro') ?>

<?php // Primary Gallery
$imgs = $page->photos()->toFiles();
if($imgs && $imgs->count() > 0): ?>
<section class="sec-gen">
	<div class="container">
		<?php if($page->photos_hdl()->isNotEmpty()): ?>
    <div class="sec-hd">
      <h2 class="rule"><?= $page->photos_hdl() ?></h2>
      <?php e($page->photos_subhd()->isNotEmpty(), '<p class="callout">'. $page->photos_subhd()->inline() .'</p>' ) ?>
    </div>
    <?php endif ?>
		<div class="gallery">
			<?php foreach($imgs as $img): ?>
			<?php if($img->video()->isNotEmpty()): ?>
			<a class="glightbox" href="<?= $img->video() ?>" data-gallery="gallery-1"<?php e($img->caption()->isNotEmpty(), ' data-description="'. $img->caption() .'"' ) ?>>
			  <img src="<?= $img->crop(400,400)->url() ?>" alt="*">
			  <div><span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M6 20.1957V3.80421C6 3.01878 6.86395 2.53993 7.53 2.95621L20.6432 11.152C21.2699 11.5436 21.2699 12.4563 20.6432 12.848L7.53 21.0437C6.86395 21.46 6 20.9812 6 20.1957Z"></path></svg></span></div>
			</a>
			<?php else: ?>
			<a class="glightbox" href="<?= $img->resize(null,1080)->url() ?>" data-gallery="gallery-1"<?php e($img->caption()->isNotEmpty(), ' data-description="'. $img->caption() .'"' ) ?>>
			  <img src="<?= $img->crop(400,400)->url() ?>" alt="*">
			</a>
			<?php endif ?>
			<?php endforeach ?>
		</div>
	</div>
</section>
<?php endif ?>

<?php // Floor Plans
$imgs = $page->plans()->toFiles();
if($imgs && $imgs->count() > 0): ?>
<section id="floorplans" class="sec-gen bg-alt plans">
	<div class="container">
		<div class="sec-hd">
      <h2 class="rule">Floor Plans</h2>
      <?php e($page->plans_shd()->isNotEmpty(), '<p class="callout">'. $page->plans_shd()->inline() .'</p>' ) ?>
    </div>
		<div class="card-grid cols-4">
			
			<?php foreach($imgs as $img): ?>
			<div class="card">
				<a 
					class="card-wrap glightbox" 
					href="<?= $img->resize(null,1080)->url() ?>"
				  data-gallery="gallery-2"
				  <?php e($img->file_title()->isNotEmpty(), 'data-title="'. $img->file_title() .'"' ) ?>>
				  <img src="<?= $img->crop(800,450)->url() ?>" alt="*">
				
					<div class="card-text">
						<?php e($img->file_title()->isNotEmpty(), '<h3>'. $img->file_title() .'</h3>' ) ?>
						<?php e($img->caption()->isNotEmpty(), '<p>'. $img->caption() .'</p>' ) ?>
						<p><span class="text-link">See Details</span></p>
						</p>
					</div>
				</a>
			</div>
			<?php endforeach ?>
		
		</div>
	</div>
</section>
<?php endif ?>

<?php // Secondary Gallery
$imgs = $page->photos2()->toFiles();
if($imgs && $imgs->count() > 0): ?>
<section class="sec-gen">
	<div class="container">
		<?php if($page->photos2_hdl()->isNotEmpty()): ?>
    <div class="sec-hd">
      <h2 class="rule"><?= $page->photos2_hdl() ?></h2>
      <?php e($page->photos2_subhd()->isNotEmpty(), '<p class="callout">'. $page->photos2_subhd()->inline() .'</p>' ) ?>
    </div>
    <?php endif ?>
		<div class="gallery">
			<?php foreach($imgs as $img): ?>
			<?php if($img->video()->isNotEmpty()): ?>
			<a class="glightbox" href="<?= $img->video() ?>" data-gallery="gallery-3"<?php e($img->caption()->isNotEmpty(), ' data-description="'. $img->caption() .'"' ) ?>>
			  <img src="<?= $img->crop(400,400)->url() ?>" alt="*">
			  <div><span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M6 20.1957V3.80421C6 3.01878 6.86395 2.53993 7.53 2.95621L20.6432 11.152C21.2699 11.5436 21.2699 12.4563 20.6432 12.848L7.53 21.0437C6.86395 21.46 6 20.9812 6 20.1957Z"></path></svg></span></div>
			</a>
			<?php else: ?>
			<a class="glightbox" href="<?= $img->resize(null,1080)->url() ?>" data-gallery="gallery-3"<?php e($img->caption()->isNotEmpty(), ' data-description="'. $img->caption() .'"' ) ?>>
			  <img src="<?= $img->crop(400,400)->url() ?>" alt="*">
			</a>
			<?php endif ?>
			<?php endforeach ?>
		</div>
	</div>
</section>
<?php endif ?>

<?php snippet('footer') ?>