<?php snippet('header') ?>

<?php snippet('intro') ?>

<section class="sec-gen bg events">
	<div class="container-med">
		
		<?php // Get upcoming events
		$items = $page->children()->listed()->filterBy('event_sdate', '>=', date('Y-m-d'))->sortBy('event_sdate', 'asc'); 
		if($items && $items->count() > 0): ?>
		<div class="list-cards">
			<?php foreach($items as $item): ?>
			<div class="list-card">
				<div class="list-card-wrap">
					<div class="list-card-img">
						<?php if($img = $item->event_img()->toFile()): ?>
						<img src="<?= $img->resize(600,null)->url() ?>" alt="event">
						<?php endif ?>
					</div>
					<div class="list-card-txt">
						<h2><?= $item->title() ?></h2>
						<?php if($item->event_sdate()->isNotEmpty()): ?>
						<time>
							<?= $item->event_sdate()->toDate('D, F j, Y') ?><?php if($item->event_stime()->isNotEmpty() && $item->event_etime()->isNotEmpty()): ?>, <?= $item->event_stime() ?> - <?= $item->event_etime()->widont() ?>
							<?php endif ?>
						</time>
						<?php endif ?>
						<?php if($item->event_location()->isNotEmpty()): ?>
						<address><?= $item->event_location()->widont() ?></address>
						<?php endif ?>
						<?php e($item->event_text()->isNotEmpty(), '<hr>'. $item->event_text()->widont() ) ?>
						<?php if($item->event_btn_link()->isNotEmpty()): ?>
						<p class="btns"><a class="btn" href="<?= $item->event_btn_link() ?>"><?php e($item->event_btn_text()->isNotEmpty(), $item->event_btn_text(), 'Click Here' ) ?></a>
						<?php endif ?>
					</div>
				</div>
			</div>
			<?php endforeach ?>
		</div>
		<?php else: ?>
		<p class="center">Check back soon.</p>
		<?php endif ?>

	</div>
</section>

<?php snippet('footer') ?>