<?php if($page->seo_content_type() != 'FAQPage'): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "<?php e($page->seo_content_type()->isNotEmpty(), $page->seo_content_type(), 'WebPage') ?>",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "<?= $page->url() ?>"
  },
  "headline": <?= json_encode($page->title()->value()) ?>,
  <?php if($page->seo_description()->isNotEmpty()): ?>
  "description": <?= json_encode($page->seo_description()->value(), JSON_UNESCAPED_UNICODE) ?>,
  <?php elseif($page->excerpt()->isNotEmpty()): ?>
  "description": <?= json_encode($page->excerpt()->value(), JSON_UNESCAPED_UNICODE) ?>,
  <?php endif ?>
  <?php if($img = $page->seo_img()->toFile()): ?>
  "image": "<?= $img->url() ?>",
  <?php elseif($img = $page->featured_img()->toFile()): ?>
  "image": "<?= $img->url() ?>",
  <?php endif ?>  
  "author": {
    "@type": "Organization",
    "name": <?= json_encode($site->title()->value()) ?>
  },
  "publisher": {
    "@type": "Organization",
    "name": <?= json_encode($site->title()->value()) ?>,
    "logo": {
      "@type": "ImageObject",
      "url": "<?= $site->url() ?>/images/logo.png"
    }
  },
  <?php if($page->pub_date()->isNotEmpty()): ?>
  "datePublished": "<?= $page->pub_date('c') ?>",
  <?php elseif($page->seo_created()->isNotEmpty()): ?>
  "datePublished": "<?= $page->seo_created()->toDate('c') ?>",
  <?php endif ?>
  "dateModified": "<?= $page->modified('c') ?>"
}
</script>
<?php endif ?>

<?php 

// If a FAQ block exists on the page include the FAQPage markup.

$faqs_block = $page->blocks()->toBlocks()->filterBy('type', 'faqs_block')->first();
if($faqs_block && $faqs_block->faqs_items()->isNotEmpty()):
  $items = $faqs_block->faqs_items()->toStructure();
?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [
    <?php foreach ($items as $i => $item): ?>
    {
      "@type": "Question",
      "name": <?= json_encode($item->faqs_q()->value(), JSON_UNESCAPED_UNICODE) ?>,
      "acceptedAnswer": {
        "@type": "Answer",
        "text": <?= json_encode($item->faqs_a()->value(), JSON_UNESCAPED_UNICODE) ?>
      }
    }<?php if ($i < $items->count() - 1): ?>,<?php endif; ?>
    <?php endforeach; ?>
  ]
}
</script>
<?php endif; ?>