<?php 

// Set page title
$pg_title = esc($page->seo_title()->or($page->title() . ' | ' . $site->title()));

// Set Meta description
$pg_descrption = esc($page->seo_description()->or($page->excerpt())->or(page('home')->seo_description())->or('Welcome to '. $site->title() .'. See what we have to offer.'));

// Set OG image
$pg_ogimg = '';
if($img = $page->seo_img()->toFile()): 
  $pg_ogimg = $img->url();
elseif($img = page('home')->seo()->toFile()): 
  $pg_ogimg = $img->url();
endif;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <meta name="description" content="<?= $pg_descrption ?>">
  <?php if(strpos($_SERVER['HTTP_HOST'], 'stage.') === 0): ?><meta name="robots" content="noindex, nofollow"><?php endif ?>  
  <meta name="twitter:card" content="<?= $pg_descrption ?>">
  <meta property="og:title" content="<?= $pg_title ?>" />
  <meta property="og:type" content="article" />
  <meta property="og:url" content="<?= $page->url() ?>" />
  <meta property="og:image" content="<?= $pg_ogimg ?>" />
  <meta property="og:description" content="<?= $pg_descrption ?>" /> 
  <title><?= $pg_title ?></title>
  <link href="/assets/images/fav.ico" rel="shortcut icon" />
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="/assets/css/glide.core.min.css">
  <link rel="stylesheet" type="text/css" href="/assets/css/glightbox.css">
  <link rel="stylesheet" type="text/css" href="/assets/css/style.css?v=<?= uniqid() ?>">
  <script src="/assets/js/glide.min.js"></script>
  <script src="/assets/js/glightbox.min.js"></script>
  <script src="/assets/js/main.js?v=<?= uniqid() ?>" defer></script>

  <!-- Google Tag Manager -->
  <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
  new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
  j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
  'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
  })(window,document,'script','dataLayer','GTM-5MLS3LXG');</script>
  <!-- End Google Tag Manager -->

  <?php snippet('schema') ?>

</head>
<body id="body" class="<?php e($page->isHomePage(), 'home', 'interior' ) ?>">

  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5MLS3LXG"
  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->

  <?php if($page->alert_text()->isNotEmpty()): ?>
  <div class="alert-ribbon">
    <div class="container">
      <?= $page->alert_text() ?>
    </div>
  </div>
  <?php endif ?>
  <header id="header">
    <div class="container">
      <a href="/" class="logo"><span class="hide"><?= $site->title() ?></span></a>
      <nav class="prime-nav">
        <ul>
          <?php // prime pages
          $pgs = $pages->listed()->not('home'); 
          foreach($pgs as $pg): ?>
          <li>
            <a<?php e($pg->isOpen(), ' class="active"') ?> href="<?= $pg->url() ?>"><?= $pg->title()->html() ?><span class="hr"></span></a>
            <?php if($pg->slug() == 'types-of-living'): ?>
            <ul>
              <?php foreach($pg->children()->listed() as $cpg): ?>
              <li><a href="<?= $cpg->url() ?>"><?= $cpg->title() ?></a></li>
              <?php endforeach ?>
            </ul>
            <?php endif ?>
          </li>
          <?php endforeach ?>
          <li><a class="btn" href="#c">Contact Us </a></li>
        </ul>
      </nav>
      <button class="mnav-toggle" onclick="toggleShow('body');">
        <svg class="mnav-open" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="36" height="36" fill="currentColor"><path d="M3 4H21V6H3V4ZM3 11H21V13H3V11ZM3 18H21V20H3V18Z"></path></svg>
        <svg class="mnav-close" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="36" height="36" fill="currentColor"><path d="M10.5859 12L2.79297 4.20706L4.20718 2.79285L12.0001 10.5857L19.793 2.79285L21.2072 4.20706L13.4143 12L21.2072 19.7928L19.793 21.2071L12.0001 13.4142L4.20718 21.2071L2.79297 19.7928L10.5859 12Z"></path></svg>
      </button>
      <!-- mobile navigation -->
      <nav class="mnav">
        <ul class="li-mnav">
          <?php foreach($pgs as $pg): ?>
          <li><a<?php e($pg->isOpen(), ' class="active"') ?> href="<?= $pg->url() ?>"><?= $pg->title()->html() ?><span class="hr"></span></a></li>
          <?php endforeach ?>
          <li><a href="#c" onclick="toggleShow('body');">Contact Us</a></li>
        </ul>
        <?php snippet('social') ?>
      </nav>
    </div>
  </header>
  <main>