
// Toggle .show class on/off any ID
function toggleShow(t) {
  var el = document.getElementById(t);
  el.classList.toggle('show');
}

// Ajax for contact form
document.getElementById('cform').addEventListener('submit', function(e) {
  e.preventDefault();
  const form = e.target;
  const formData = new FormData(form);
  fetch('/process-form', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      window.location.href = data.redirect_url;
    } else {
      document.getElementById('cform-alert').innerHTML = data.error;
    }
  })
  .catch(error => {
    document.getElementById('cform-alert').innerHTML = '<p class="alert">An error occurred while submitting the form.</a>';
  });
});

// Initialize GLightbox only if needed
document.addEventListener("DOMContentLoaded", function () {
  if (document.querySelector('.glightbox')) {
    GLightbox({
      selector: '.glightbox', 
      zoomable: false,
      videosWidth: '1280px',
      svg: {
        next: '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M17 6 17 18H15L15 6 17 6ZM13 12 7 18V6L13 12Z"></path></svg>',
        prev: '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M7 18V6H9V18H7ZM11 12 17 6V18L11 12Z"></path></svg>',
        close: '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M10.5859 12L2.79297 4.20706L4.20718 2.79285L12.0001 10.5857L19.793 2.79285L21.2072 4.20706L13.4143 12L21.2072 19.7928L19.793 21.2071L12.0001 13.4142L4.20718 21.2071L2.79297 19.7928L10.5859 12Z"></path></svg>',
        download: '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M4 19H20V12H22V20C22 20.5523 21.5523 21 21 21H3C2.44772 21 2 20.5523 2 20V12H4V19ZM14 9H19L12 16L5 9H10V3H14V9Z"></path></svg>'
      }
    });
  }
});